<?php
if (!isset($objet) && !isset($title) && !isset($region)) {
    $content = file_get_contents($_GET["mail"] . '/config.json');
    $json = json_decode($content, true);
    extract($json, EXTR_PREFIX_SAME, "wddx");

    if (isset($params)) {
        $page = array_keys($json['params'])[0];
        $params = $json['params'][$page];
        if (isset($index) && isset($json['params'][$index])) {
            $params = $json['params'][$index];
        } elseif (isset($_GET['page']) && isset($json['params'][$_GET['page']])) {
            $params = $json['params'][$_GET['page']];
            $page = $_GET['page'];
        }
        extract($params, EXTR_PREFIX_SAME, "wddx");
        $data = file_get_contents($_GET["mail"] . '/data/' . $page . '.json');
        $json = json_decode($data, true);
        extract($json, EXTR_PREFIX_SAME, "wddx");
    }
}

$fmt = new IntlDateFormatter(
    'fr_FR',
    IntlDateFormatter::FULL,
    IntlDateFormatter::FULL,
    'Europe/Paris',
    IntlDateFormatter::GREGORIAN,
    'MMMM yyyy',
);
$title = 'Newsletter ' . $fmt->format(time());
?>

<!DOCTYPE html>
<html lang='fr' xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'>
    <head>
        <meta charset='utf-8'>
        <meta name='viewport' content='width=device-width'>
        <meta http-equiv='X-UA-Compatible' content='IE=edge'>
        <meta name='x-apple-disable-message-reformatting'>
        <meta name='format-detection' content='telephone=no,address=no,email=no,date=no,url=no'>
        <meta name='color-scheme' content='light'>
        <meta name='supported-color-schemes' content='light'>
        <title><?php echo $title; ?></title>
        <!--[if gte mso 9]>
        <xml>
            <o:OfficeDocumentSettings>
                <o:AllowPNG/>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
        <![endif]-->
        <style>
            :root {color-scheme: light;}
            html,
            body {margin: 0 auto !important;padding: 0 !important;height: 100% !important;width: 100% !important;font-family: Arial, Helvetica, sans-serif !important;}
            * {-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;}
            div[style*='margin: 16px 0'] {margin: 0 !important;}
            table,td {mso-table-lspace: 0pt !important;mso-table-rspace: 0pt !important;}
            th {font-weight: normal;}
            table {border-spacing: 0 !important;border-collapse: collapse !important;table-layout: fixed !important;margin: 0 auto !important;mso-table-lspace: 0pt !important;mso-table-rspace: 0pt !important;}
            a {text-decoration: none;}
            p, a, h1, h2,h3,h4,h5,h6,span,b,i,strong{font-family: Arial, sans-serif !important;}
            ul{margin:0 !important;padding: 0 0 0 10px !important;}
            li{margin:0 !important;}
            a[x-apple-data-detectors],
            .unstyle-auto-detected-links a,
            .aBn {border-bottom: 0 !important;cursor: default !important;color: inherit !important;text-decoration: none !important;font-size: inherit !important;font-family: inherit !important;font-weight: inherit !important;line-height: inherit !important;}
            .im {color: inherit !important;}
            .a6S {display: none !important;opacity: 0.01 !important;}
            img.g-img+div {display: none !important;}
            .display{display: none !important;max-height:0;}
            .br-mb{ display: none !important;}
            @media screen and (max-width: 670px) {
                .display-none {display: none !important;}    
                .center {margin: 0 auto !important}
                .center_t {text-align: center !important;height: auto !important}
                .email-container {width: 100% !important;margin: auto !important;}
                .stack-column-center {display: block !important;width: 100% !important;max-width: 100% !important;direction: ltr !important;padding-left: 0 !important;padding-right: 0 !important;text-align: center !important;}
                .stack-column-center-90{display: block !important;width: 90% !important;max-width: 90% !important;direction: ltr !important;padding-left: 0 !important;padding-right: 0 !important;/* text-align: center !important; */margin: 0 auto;}
                .stack-column-left{display: block !important;width: 100% !important;max-width: 100% !important;direction: ltr !important;padding-left: 0 !important;padding-right: 0 !important;text-align: left !important;}
                .center-on-narrow {text-align: center !important;display: block;margin-left: auto !important;margin-right: auto !important;float: none !important;}
                table.center-on-narrow {display: inline-block !important;}
                .display{display:block !important;max-height:none !important;mso-hide:none !important;overflow: visible !important;visibility:visible !important;margin: 0 auto !important;text-align:center !important;}
                .br-mb{display: table-cell !important;}
                .img-mob {display: block !important;width: 100% !important;max-width: 100% !important;padding-left: 0!important;padding-right: 0!important;mso-hide:none!important;max-height:none!important;overflow:visible!important;visibility:visible!important;}
                .font-mb{font-size:13px !important;}
                .btn-fw-m{line-height: 20px !important; width: 250px !important; padding:10px 0 !important;}
                .pad{padding-bottom:20px !important;padding-left:30px !important;}
            }
        </style>
    </head>
    <body>
        <center aria-roledescription="email" lang="fr" style="width: 100%; background-color: #F2F2F2;">
            <!--[if mso | IE]>
            <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%" style="background-color: #F2F2F2;">
            <tr>
            <td>
            <![endif]-->
            <table align="center" role="presentation" cellspacing="0" cellpadding="0" border="0" width="670" style="border: 0;margin: auto;" class="email-container">
                <tr>
                    <td style="padding: 20px 10px; background-color: #FFFFFF;text-align: center;" align="center">
                        <p style="margin:0;text-align:center;font-size:12px;">
                            <?php echo $title; ?>
                            <br />Si le message ne s'affiche pas correctement, <a href="{{tracking.webcopy}}" title="Mirror page" sb-type="WEBCOPY">cliquez ici</a>
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="center" style="padding:30px 30px 30px;background-color:#42145f;">
                        <a _category="CONSEILS" title="Cogedim ImmoNews" href="https://www.cogedim.com/" target="_blank">
                            <img src="images/logo_immonews.png" alt="Cogedim ImmoNews" style="max-width:100%;display: block; margin: 0 auto;" />
                        </a>
                    </td>
                </tr>
                <!-- img full -->
                <tr>
                    <td align="center" style="padding:0 30px 0;background-color:#42145f;">
                        <a href="<?php echo $tracking['doubleclick']['content']['actualite'] . $contents['actualite']['url'] . $tracking['utms']['content']['actualite']; ?>" target="_blank">
                            <img src="images/<?php echo $contents['actualite']['img']['name']; ?>" alt="<?php echo $contents['actualite']['img']['alt']; ?>" class="img-mob center_t" style="max-width:100%;display: block; margin: 0 auto;" />
                        </a>
                    </td>
                </tr>
                <!-- promotion titre encadré + bouton VML ok -->
                <tr>
                    <td style="padding: 20px 30px 40px;background-color: #42145f;">
                        <table align="center" role="presentation" width="85%" class="email-container" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                <td style="padding:0 0 10px;" align="center">
                                    <h1 class="l-h-38" style="margin:0;text-align:left;font-size:40px;line-height: normal;">
                                        <a style="text-decoration:none;color:#FFFFFF" href="<?php echo $tracking['doubleclick']['content']['actualite'] . $contents['actualite']['url'] . $tracking['utms']['content']['actualite']; ?>" target="_blank">
                                            <?php echo $contents['actualite']['title']; ?>
                                        </a>
                                    </h1>
                                    <p style="margin:34px 0 20px;text-align:left;font-size:13px;font-weight:normal;">
                                        <a style="text-decoration:none;color:#FFFFFF" href="<?php echo $tracking['doubleclick']['content']['actualite'] . $contents['actualite']['url'] . $tracking['utms']['content']['actualite']; ?>" target="_blank">
                                            <?php echo $contents['actualite']['text']; ?>
                                        </a>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding:5px 0 0" class="stack-column-center">
                                    <table align="left" role="presentation" cellspacing="0" cellpadding="0" border="0" style="display:block;">
                                        <tr>
                                            <td>
                                                <div><!--[if mso]>
                                                    <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="<?php echo $tracking['doubleclick']['content']['actualite'] . $contents['actualite']['url'] . $tracking['utms']['content']['actualite']; ?>" style="height:50px;v-text-anchor:middle;width:170px;" arcsize="75%" stroke="f" fillcolor="#a31a7e">
                                                      <w:anchorlock/>
                                                      <center>
                                                    <![endif]-->
                                                        <a href="<?php echo $tracking['doubleclick']['content']['actualite'] . $contents['actualite']['url'] . $tracking['utms']['content']['actualite']; ?>" style="background-color:#a31a7e;border-radius:30px;color:#ffffff;display:inline-block;font-family:sans-serif;font-size:14px;font-weight:bold;line-height:50px;text-align:center;text-decoration:none;width:170px;-webkit-text-size-adjust:none;">
                                                            <?php echo $contents['actualite']['cta']; ?>
                                                        </a>
                                                    <!--[if mso]>
                                                      </center>
                                                    </v:roundrect>
                                                  <![endif]--></div>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <?php if (isset($contents['conseils1']) || isset($contents['conseils2'])): ?>
                <tr>
                    <td style="padding: 0 30px 10px;background-color: #ffffff;">
                        <table role="presentation" align="center" width="520" class="email-container" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                <td style="padding:30px 0 30px;" align="center">
                                    <h2 style="margin:0;text-align:left;font-size:35px;">
                                        <a style="text-decoration:none;color:#42145f" href="<?php echo $url; ?>" target="_blank">
                                            Nos conseils
                                            <br class="display-none"/>immobiliers
                                        </a>
                                    </h2>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding:0;background-color:#ffffff;">
                                    <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                        <?php if (isset($contents['conseils1'])): ?>
                                        <tr>
                                            <th width="50%" style="padding:0 0 20px;border:0;vertical-align:middle;" class="stack-column-center" align="left">
                                                <a href="<?php echo $tracking['doubleclick']['content']['conseils1'] . $contents['conseils1']['url'] . $tracking['utms']['content']['conseils1']; ?>" target="_blank">
                                                    <img class="img-mob" src="images/<?php echo $contents['conseils1']['img']['name']; ?>" width="222" alt="C'est le moment d'en profiter !" style="width:222px;max-width:100%;display: block;border:0;" />
                                                </a>
                                            </th>
                                            <th dir="ltr" width="50%" style="padding:0 0 20px;vertical-align:middle;" class="stack-column-center">
                                                <table role="presentation" width="75%" class="email-container" align="center" cellspacing="0" cellpadding="0" border="0">
                                                    <tr>
                                                        <td align="left" style="padding:15px 0 0">
                                                            <h3 style="margin:0;font-size:16px;font-weight:bold;line-height:normal;color:#42145f">
                                                                <a style="text-decoration:none;color:#42145f" href="<?php echo $tracking['doubleclick']['content']['conseils1'] . $contents['conseils1']['url'] . $tracking['utms']['content']['conseils1']; ?>" target="_blank">
                                                                    <?php echo $contents['conseils1']['title']; ?>
                                                                </a>
                                                            </h3>
                                                            <p style="margin:15px 0;font-size:14px;line-height: normal;color:#42145f;">
                                                                <a style="text-decoration:none;color:#42145f" href="<?php echo $tracking['doubleclick']['content']['conseils1'] . $contents['conseils1']['url'] . $tracking['utms']['content']['conseils1']; ?>" target="_blank">
                                                                    <?php echo $contents['conseils1']['text']; ?>
                                                                </a>
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="padding:0 0 15px 0;" align="left">
                                                            <table align="left" width="100%" role="presentation" cellspacing="0" cellpadding="0" border="0" >
                                                                <tr>
                                                                    <td>
                                                                        <div>
                                                                            <!--[if mso]>
                                                                            <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="<?php echo $tracking['doubleclick']['content']['conseils1'] . $contents['conseils1']['url'] . $tracking['utms']['content']['conseils1']; ?>" style="height:50px;v-text-anchor:middle;width:135px;" arcsize="75%" stroke="f" fillcolor="#00b2a9">
                                                                                <w:anchorlock/>
                                                                                <center>
                                                                            <![endif]-->
                                                                                <a href="<?php echo $tracking['doubleclick']['content']['conseils1'] . $contents['conseils1']['url'] . $tracking['utms']['content']['conseils1']; ?>" style="background-color:#00b2a9;border-radius:30px;color:#ffffff;display:inline-block;font-family:sans-serif;font-size:14px;font-weight:bold;line-height:50px;text-align:center;text-decoration:none;width:135px;-webkit-text-size-adjust:none;">
                                                                                    <?php echo $contents['conseils1']['cta']; ?>
                                                                                </a>
                                                                            <!--[if mso]>
                                                                                </center>
                                                                            </v:roundrect>
                                                                            <![endif]-->
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </th>
                                        </tr>
                                        <?php endif; ?>

                                        <?php if (isset($contents['conseils2'])): ?>
                                        <tr>
                                            <th width="50%" style="padding:0 0 20px;border:0;vertical-align:middle;" class="stack-column-center" align="left">
                                                <a href="<?php echo $tracking['doubleclick']['content']['conseils2'] . $contents['conseils2']['url'] . $tracking['utms']['content']['conseils2']; ?>" target="_blank">
                                                    <img class="img-mob" src="images/<?php echo $contents['conseils2']['img']['name']; ?>" width="222" alt="<?php echo $contents['conseils2']['img']['alt']; ?>" style="width:222px;max-width:100%;display: block;border:0;" />
                                                </a>
                                            </th>
                                            <th dir="ltr" width="50%" style="padding:0 0 20px;vertical-align:middle;" class="stack-column-center">
                                                <table role="presentation" width="75%" class="email-container" align="center" cellspacing="0" cellpadding="0" border="0">
                                                    <tr>
                                                        <td align="left" style="padding:15px 0 0">
                                                            <h3 style="margin:0;font-size:16px;font-weight:bold;line-height:normal;color:#42145f">
                                                                <a style="text-decoration:none;color:#42145f" href="<?php echo $tracking['doubleclick']['content']['conseils2'] . $contents['conseils2']['url'] . $tracking['utms']['content']['conseils2']; ?>" target="_blank">
                                                                    <?php echo $contents['conseils2']['title']; ?>
                                                                </a>
                                                            </h3>
                                                            <p style="margin:15px 0;font-size:14px;line-height: normal;color:#42145f;">
                                                                <a style="text-decoration:none;color:#42145f" href="<?php echo $tracking['doubleclick']['content']['conseils2'] . $contents['conseils2']['url'] . $tracking['utms']['content']['conseils2']; ?>" target="_blank">
                                                                    <?php echo $contents['conseils2']['text']; ?>
                                                                </a>
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="padding:0 0 15px 0;" align="left">
                                                            <table align="left" width="100%" role="presentation" cellspacing="0" cellpadding="0" border="0" >
                                                                <tr>
                                                                    <td>
                                                                        <div>
                                                                            <!--[if mso]>
                                                                            <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="<?php echo $tracking['doubleclick']['content']['conseils2'] . $contents['conseils2']['url'] . $tracking['utms']['content']['conseils2']; ?>" style="height:50px;v-text-anchor:middle;width:135px;" arcsize="75%" stroke="f" fillcolor="#00b2a9">
                                                                                <w:anchorlock/>
                                                                                <center>
                                                                            <![endif]-->
                                                                                <a href="<?php echo $tracking['doubleclick']['content']['conseils2'] . $contents['conseils2']['url'] . $tracking['utms']['content']['conseils2']; ?>" style="background-color:#00b2a9;border-radius:30px;color:#ffffff;display:inline-block;font-family:sans-serif;font-size:14px;font-weight:bold;line-height:50px;text-align:center;text-decoration:none;width:135px;-webkit-text-size-adjust:none;">
                                                                                    <?php echo $contents['conseils2']['cta']; ?>
                                                                                </a>
                                                                            <!--[if mso]>
                                                                                </center>
                                                                            </v:roundrect>
                                                                            <![endif]-->
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </th>
                                        </tr>
                                        <?php endif; ?>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <?php endif; ?>

                <?php if (isset($contents['cnat'])): ?>
                <tr>
                    <td style="padding:20px 20px;background-color:#42145f;">
                        <table role="presentation" class="stack-column-center" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr>
                                <th style="vertical-align:middle;background-color: #FFFFFF;padding:0;" class="stack-column-center" >
                                    <table role="presentation" align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <th class="stack-column-center" align="left">
                                                <a href="<?php echo $tracking['doubleclick']['content']['cnat'] . $contents['cnat']['url'] . $tracking['utms']['content']['cnat']; ?>" target="_blank">
                                                    <img class="img-mob" src="images/<?php echo $contents['cnat']['img']['name']; ?>" width="188" alt="" style="width:188px;max-width:100%;display: block;margin:0 auto">
                                                </a>
                                            </th>
                                            <th style="padding:0;vertical-align:middle;background-color: #FFFFFF;" class="stack-column-center">
                                                <table width="100%" role="presentation" align="center" cellspacing="0" cellpadding="0" border="0">
                                                    <tr>
                                                        <td style="padding:20px 0 20px 20px;background-color: #FFFFFF;" class="email-container">
                                                            <p style="margin:0;font-size:26px;font-weight:bold;text-align: left;mso-line-height-rule:exactly;line-height:normal;">
                                                                <a style="text-decoration:none;color:#42145f" href="<?php echo $tracking['doubleclick']['content']['cnat'] . $contents['cnat']['url'] . $tracking['utms']['content']['cnat']; ?>" target="_blank">
                                                                    <?php echo $contents['cnat']['title']; ?>
                                                                </a>
                                                            </p>
                                                            <p style="margin:0;font-size:20px;font-weight:bold;text-align:left;mso-line-height-rule:exactly;">
                                                                <a style="text-decoration:none;color:#00b2a9" href="<?php echo $tracking['doubleclick']['content']['cnat'] . $contents['cnat']['url'] . $tracking['utms']['content']['cnat']; ?>" target="_blank">
                                                                    <?php echo $contents['cnat']['subtitle']; ?>
                                                                </a>
                                                            </p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </th>
                                        </tr>
                                    </table>
                                </th>
                                <th style="vertical-align:middle;background-color:#42145f;padding:0" class="stack-column-center" width="255">
                                    <table class="stack-column-center" style="display: none;" role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td aria-hidden="true" height="15px">&nbsp;</td>
                                        </tr>
                                    </table>
                                    <table role="presentation" class="email-container" cellspacing="0" cellpadding="0" align="center" border="0">
                                        <tr>
                                            <td class="stack-column-center" style="padding:0 0 0 15px" align="center">
                                                <p style="margin:0;font-size:20px;font-weight:bold;text-align:left;">
                                                    <a style="text-decoration:none;color:#FFFFFF" href="<?php echo $tracking['doubleclick']['content']['cnat'] . $contents['cnat']['url'] . $tracking['utms']['content']['cnat']; ?>" target="_blank">
                                                        <?php echo $contents['cnat']['text']; ?>
                                                    </a>
                                                </p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding:20px 0 20px 15px" align="left"  class="stack-column-center">
                                                <table role="presentation" class="stack-column-center" cellspacing="0" align="left" cellpadding="0" border="0" >
                                                    <tr>
                                                        <td>
                                                            <div><!--[if mso]>
                                                                <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="<?php echo $tracking['doubleclick']['content']['cnat'] . $contents['cnat']['url'] . $tracking['utms']['content']['cnat']; ?>" style="height:50px;v-text-anchor:middle;width:170px;" arcsize="75%" stroke="f" fillcolor="#a31a7e">
                                                                <w:anchorlock/>
                                                                <center>
                                                                <![endif]-->
                                                                    <a href="<?php echo $tracking['doubleclick']['content']['cnat'] . $contents['cnat']['url'] . $tracking['utms']['content']['cnat']; ?>" style="background-color:#a31a7e;border-radius:30px;color:#ffffff;display:inline-block;font-family:sans-serif;font-size:14px;font-weight:bold;line-height:50px;text-align:center;text-decoration:none;width:170px;-webkit-text-size-adjust:none;">
                                                                        <?php echo $contents['cnat']['cta']; ?>
                                                                    </a>
                                                                <!--[if mso]>
                                                                </center>
                                                                </v:roundrect>
                                                            <![endif]--></div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </th>
                            </tr>
                        </table>
                    </td>
                </tr>
                <?php endif; ?>

                <tr>
                    <td style="padding:0;background-color: #f3f3f3;">
                        <table role="presentation" align="center" width="580" class="email-container" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                <td style="padding:30px" align="center">
                                    <h2 style="margin:0;text-align:left;font-size:35px;">
                                        <a style="text-decoration:none;color:#42145f" href="<?php echo $tracking['doubleclick']['programs'] . $all_url  . $tracking['utms']['programs']; ?>" target="_blank">
                                            <?php if($page != 'invest'): ?>
                                                Notre sélection de résidences en <?php echo $name; ?>
                                            <?php else: ?>
                                                Notre sélection
                                                <br class="display-none" />de résidences pour investir
                                            <?php endif ?>
                                        </a>
                                    </h2>
                                </td>
                            </tr>
                        </table>
                        <?php foreach ($programs as $i => $program): ?>
                            <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tr>
                                    <td style="padding:0;background-color:#f3f3f3;">
                                        <?php if (count($programs) % 2 == 1 && $i == count($programs) - 1): ?>
                                            <?php include('single_program.php'); ?>
                                        <?php else: ?>
                                            <?php if ($i % 2 == 0): ?>
                                                <?php include('two_programs.php'); ?>
                                            <?php endif ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </table>
                        <?php endforeach; ?>
                    </td>
                </tr>
                <tr>
                    <td style="padding:20px 20px 20px" class="stack-column-center">
                        <table align="center" role="presentation" cellspacing="0" cellpadding="0" border="0" >
                            <tr>
                                <td>
                                    <div><!--[if mso]>
                                        <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="<?php echo $tracking['doubleclick']['programs'] . $all_url . $tracking['utms']['programs']; ?>" style="height:50px;v-text-anchor:middle;width:307px;" arcsize="75%" stroke="f" fillcolor="#42145f">
                                          <w:anchorlock/>
                                          <center>
                                        <![endif]-->
                                            <a href="<?php echo $tracking['doubleclick']['programs'] . $all_url . $tracking['utms']['programs']; ?>" style="background-color:#42145f;border-radius:30px;color:#ffffff;display:inline-block;font-family:sans-serif;font-size:13px;font-weight:bold;line-height:50px;text-align:center;text-decoration:none;width:307px;-webkit-text-size-adjust:none;">
                                                Trouvez le bien qui vous correspond
                                            </a>
                                        <!--[if mso]>
                                          </center>
                                        </v:roundrect>
                                      <![endif]--></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td align="center" style="padding:30px 0;background-color: #ffffff;">
                        <table role="presentation" align="center" width="580" class="email-container" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                <td style="padding:0 30px 30px" align="center">
                                    <h2 style="margin:0;text-align:left;font-size:35px;">
                                        <a style="text-decoration:none;color:#42145f" href="<?php echo $url; ?>" target="_blank">
                                            Vos outils pour
                                            <br />concrétiser votre&nbsp;projet
                                        </a>
                                    </h2>
                                </td>
                            </tr>
                        </table>
                        <table role="presentation" align="center" width="530" class="email-container" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                <th width="50%" style="padding:0;vertical-align:middle;" class="stack-column-center">
                                    <table role="presentation" border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
                                        <tr>
                                            <th style="padding:0 0 10px;border:0;">
                                                <a href="<?php echo $tracking['doubleclick']['simulateurs']['pinel'] . "https://www.cogedim.com/investir/les-outils-pour-preparer-mon-investissement/simulation-pinel.html" . $tracking['utms']['simulateurs']['pinel']; ?>" target="_blank">
                                                    <img src="images/pinel.png" alt="Pinel" style="max-width:100%;display: block;border:0;margin:0 auto;" />
                                                </a>
                                            </th>
                                        </tr>
                                    </table>
                                </th>
                                <th width="50%" style="padding:0;vertical-align:middle;" class="stack-column-center">
                                    <table role="presentation" border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
                                        <tr>
                                            <th style="padding:0 0 10px;border:0;">
                                                <a href="<?php echo $tracking['doubleclick']['simulateurs']['emprunt'] . "https://www.cogedim.com/calcul-capacite-d-emprunt.html" . $tracking['utms']['simulateurs']['emprunt']; ?>" target="_blank">
                                                    <img src="images/emprunt.png" alt="Emprunt" style="max-width:100%;display: block;border:0;margin:0 auto;" />
                                                </a>
                                            </th>
                                        </tr>
                                    </table>
                                </th>
                            </tr>
                            <tr>
                                <th align="center" width="50%" style="padding:0;vertical-align:middle;" class="stack-column-center">
                                    <table role="presentation" border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
                                        <tr>
                                            <th style="padding:0 0 10px;border:0;">
                                                <a href="<?php echo $tracking['doubleclick']['simulateurs']['lmnp'] . "https://www.cogedim.com/investir/les-outils-pour-preparer-mon-investissement/simulation-lmnp.html" . $tracking['utms']['simulateurs']['lmnp']; ?>" target="_blank">
                                                    <img src="images/lmnp.png" alt="LMNP" style="max-width:100%;display: block;border:0;margin:0 auto" />
                                                </a>
                                            </th>
                                        </tr>
                                    </table>
                                </th>
                                <th width="50%" style="padding:0 0 10px;vertical-align:middle;" class="stack-column-center">
                                    <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                        <tr>
                                            <th style="padding:0px;border:0;">
                                                <a href="<?php echo $tracking['doubleclick']['simulateurs']['mensualites'] . "https://www.cogedim.com/calcul-mensualites.html" . $tracking['utms']['simulateurs']['mensualites']; ?>" target="_blank">
                                                    <img src="images/mensualites.png" alt="Mensualités" style="max-width:100%;display: block;border:0;margin:0 auto" />
                                                </a>
                                            </th>
                                        </tr>
                                    </table>
                                </th>
                            </tr>
                        </table>
                    </td>
                </tr>


                <?php if (isset($contents['biens'])): ?>
                <tr>
                    <td style="padding: 20px 0;background-color:#42145f;">
                        <table role="presentation" align="center" width="580" class="email-container" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                <td style="padding:10px 30px 20px" align="center">
                                    <h2 style="margin:0;text-align:left;font-size:40px;">
                                        <a style="text-decoration:none;color:#FFFFFF" href="<?php echo $tracking['doubleclick']['content']['biens'] . $contents['biens']['url'] . $tracking['utms']['content']['biens'];; ?>" target="_blank">
                                            Des biens qui font du bien
                                        </a>
                                    </h2>
                                </td>
                            </tr>
                        </table>

                        <!-- biens -->
                        <?php if (isset($contents['biens'])): ?>
                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                            <tr>
                                <td align="center" style="padding:0 30px;background-color:#42145f;">
                                    <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                                        <tr>
                                            <th width="50%" style="padding:0;vertical-align:middle;" class="stack-column-center">
                                                <a href="<?php echo $tracking['doubleclick']['content']['biens'] . $contents['biens']['url'] . $tracking['utms']['content']['biens']; ?>" target="_blank">
                                                    <img class="img-mob" src="images/<?php echo $contents['biens']['img']['name']; ?>" alt="<?php echo $contents['biens']['img']['alt']; ?>" width="305" style="width:305px;max-width:100%;display: block;border:0;" />
                                                </a>
                                            </th>
                                            <!--colonne 1 end-->

                                            <!-- colonne 2 start-->
                                            <th width="50%" style="padding:0;vertical-align:middle;" class="stack-column-center">
                                                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                    <tr>
                                                        <td style="padding:20px 0">
                                                            <table role="presentation" width="255" align="center" class="email-container" cellspacing="0" class="" cellpadding="0" border="0">
                                                                <tr>
                                                                    <td align="left">
                                                                        <table role="presentation" cellspacing="0" width="100%" cellpadding="0" border="0" style="background-color: #42145f;" class="stack-column-center" align="left">
                                                                            <tr>
                                                                                <td style="padding :0" align="left">
                                                                                    <table role="presentation" cellspacing="0" cellpadding="0" border="0" align="left">
                                                                                        <tr>
                                                                                            <td style="padding:5px 10px;background-color:#ffffff" align="left">
                                                                                                <p style="color: #42145f;margin:0;font-size:14px;line-height:normal;font-weight:bold;">
                                                                                                    ENGAGEMENT N°<?php echo $contents['biens']['engagement']; ?>
                                                                                                </p>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                        <table role="presentation" cellspacing="0" cellpadding="0" border="0" align="left">
                                                                            <tr>
                                                                                <td align="left">
                                                                                    <h3 style="margin:10px 0;font-size:20px;font-weight:bold;line-height:normal;">
                                                                                        <a style="text-decoration:none;color:#00b2a9" href="<?php echo $tracking['doubleclick']['content']['biens'] . $contents['biens']['url'] . $tracking['utms']['content']['biens']; ?>" target="_blank">
                                                                                            <?php echo $contents['biens']['title']; ?>
                                                                                        </a>
                                                                                    </h3>
                                                                                    <p style="margin:10px 0;font-size:14px;line-height: normal;color:#ffffff;">
                                                                                        <a style="text-decoration:none;color:#ffffff" href="<?php echo $tracking['doubleclick']['content']['biens'] . $contents['biens']['url'] . $tracking['utms']['content']['biens']; ?>" target="_blank">
                                                                                            <?php echo $contents['biens']['text']; ?>
                                                                                        </a>
                                                                                    </p>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="padding:10px 0;">
                                                                        <table align="left" role="presentation" cellspacing="0" cellpadding="0" border="0" >
                                                                            <tr>
                                                                                <td>
                                                                                    <div>
                                                                                        <!--[if mso]>
                                                                                        <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="<?php echo $tracking['doubleclick']['content']['biens'] . $contents['biens']['url'] . $tracking['utms']['content']['biens']; ?>" style="height:50px;v-text-anchor:middle;width:150px;" arcsize="75%" stroke="f" fillcolor="#00b2a9">
                                                                                          <w:anchorlock/>
                                                                                          <center>
                                                                                        <![endif]-->
                                                                                            <a href="<?php echo $tracking['doubleclick']['content']['biens'] . $contents['biens']['url'] . $tracking['utms']['content']['biens']; ?>" style="background-color:#00b2a9;border-radius:30px;color:#ffffff;display:inline-block;font-family:sans-serif;font-size:14px;font-weight:bold;line-height:50px;text-align:center;text-decoration:none;width:150px;-webkit-text-size-adjust:none;">
                                                                                                <?php echo $contents['biens']['cta']; ?>
                                                                                            </a>
                                                                                        <!--[if mso]>
                                                                                          </center>
                                                                                        </v:roundrect>
                                                                                      <![endif]-->
                                                                                    </div>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </th>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endif; ?>

                <tr>
                    <td style="padding:30px;background-color:#f3f3f3;">
                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                            <tr>
                                <td style="vertical-align:middle;" width="140" class="stack-column-center">
                                    <a href="<?php echo $tracking['doubleclick']['footer'] . $url . $tracking['utms']['footer']; ?>" target="_blank">
                                        <img src="images/service-client.png" alt="Service client 2022" style="height:auto;display:block;margin:0 auto;" />
                                    </a>
                                </td>
                                <td style="vertical-align:middle;" class="stack-column-center">
                                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td style="padding:15px">
                                                <p style="margin:0;font-size:28px;font-weight:bold;">
                                                    <a style="text-decoration:none;color:#3c145f" href="<?php echo $tracking['doubleclick']['footer'] . $url . $tracking['utms']['footer']; ?>" target="_blank">
                                                        L'accompagnement<br /> de nos clients est notre priorité.
                                                    </a>
                                                </p>
                                                <p style="margin:10px 0;font-size:14px;">
                                                    <a  style="text-decoration:none;color:#42145f" href="<?php echo $tracking['doubleclick']['footer'] . $url . $tracking['utms']['footer']; ?>" target="_blank">
                                                        C’est pourquoi Cogedim a été Élu Service Client de l’Année
                                                        <br class="display-none" />pour la 6<sup>e</sup> année* consécutive.
                                                    </a>
                                                </p>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td style="padding:30px 30px 20px; background-color: #FFFFFF;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <th valign="bottom" style="width:50%;padding:0 0 30px;vertical-align:top;border:0;" class="stack-column-center">
                                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td style="padding:0;" align="left" class="center_t">
                                                <a href="<?php echo $cta_url . $tracking['utms']['cta_rdv']; ?>&form=advisor&subject=2" target="_blank">
                                                    <img class="center" src="images/prendre-rdv.png" alt="Prendre rendez-vous" style="display:block;height:auto;"/>
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                </th>
                                <th valign="bottom" style="width:50%;padding:0 0 30px;vertical-align:top;border:0;" class="stack-column-center">
                                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td style="padding:0;" align="right" class="center_t">
                                                <a href="<?php echo $cta_url . $tracking['utms']['cta_call']; ?>&form=advisor&subject=3" target="_blank">
                                                    <img class="center" src="images/etre-appele.png" alt="être appelé" style="display:block;height:auto;" />
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                </th>
                            </tr>
                        </table>
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <!--colonne 1 start-->
                                <th style="padding: 0 0 10px;vertical-align:middle;border:0;" width="120" class="stack-column-center">
                                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td style="padding:0 0 10px" align="left" class="stack-column-center">
                                                <a href="<?php echo $tracking['doubleclick']['footer'] . $url . $tracking['utms']['footer']; ?>" target="_blank">
                                                    <img class="center" src="images/logo-cogedim.jpg" alt="Logo Cogedim" style="height: auto;display: block;" />
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                </th>
                                <!--colonne 1 end-->

                                <!-- colonne 2 start-->
                                <th style="padding: 0 0 10px;vertical-align:bottom;border:0;" class="stack-column-center">
                                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td style="padding:10px" align="center" class="stack-column-center">
                                                <a href="tel:0970255255" target="_blank">
                                                    <img src="images/numero-vert.png" alt="Numéro vert" style="height: auto;margin:0 auto" />
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding:0 0 20px;color:#42145f;" align="center">
                                                <a href="<?php echo $tracking['doubleclick']['footer'] . $url . $tracking['utms']['footer']; ?>" style="color:#42145f;text-decoration:none;font-size:24px;font-weight: bold;" target="_blank">
                                                    cogedim.com
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                </th>
                                <!--colonne 2 end-->
                                <!--color 3 start-->
                                <th style="padding: 0 0 10px;vertical-align:top;border:0;" width="80" class="stack-column-center">
                                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" align="center" >
                                      <tr>
                                            <td class="center" align="right" width="80">
                                                <table role="presentation" width="80" cellspacing="0" cellpadding="0" border="0" align="center">
                                                    <tr>
                                                        <td width="35">
                                                            <a href="https://www.instagram.com/cogedim/" target="_blank">
                                                                <img src="images/insta.png" alt="Instagram" style="height: auto;margin:0 auto" />
                                                            </a>
                                                        </td>
                                                        <td width="35">
                                                            <a href="https://www.linkedin.com/company/cogedim/" target="_blank">
                                                                <img src="images/linkedin.png" alt="Linkedin" style="height: auto;margin:0 auto" />
                                                            </a>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td aria-hidden="true" style="line-height:5px;font-size:5px;">&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td class="center" align="right" width="80">
                                                <table role="presentation" width="80" cellspacing="0" cellpadding="0" border="0" align="center">
                                                    <tr>
                                                        <td width="35">
                                                            <a href="https://www.facebook.com/cogedim/" target="_blank">
                                                                <img src="images/facebook.png" alt="Facebook" style="height: auto;" />
                                                            </a>
                                                        </td>
                                                        <td width="35">
                                                            <a href="https://www.youtube.com/user/CogedimLogement" target="_blank">
                                                                <img src="images/youtube.png" alt="Youtube" style="height: auto;" />
                                                            </a>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </th>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td style="padding:0;background-color:#FFFFFF;">
                        <a _category="FOOTER" title="Altarea Cogedim" href="<?php echo $tracking['doubleclick']['footer'] . $url . $tracking['utms']['footer']; ?>" target="_blank">
                            <img src="images/lignealtaera.jpg" alt="Altarea Cogedim" style="width:100%;max-width:100%;display: block; margin: 0 auto;">
                        </a>
                    </td>
                </tr>
                <!-- ML -->
                <tr>
                    <td style="padding:0 30px 20px; background-color:#FFFFFF;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td style="padding:20px 0">
                                    <p style="margin:0;text-align:center;color:#48484c;font-size:12px;">
                                        <b class="base-cov-ml" style="font-size: 13px;">
                                            Comme tout investissement, investir avec le dispositif Pinel ou en statut Loueur Meublé Non Professionnel peut présenter des risques. Le non-respect des engagements entraîne la perte du bénéfice des incitations fiscales. Détail sur <a href="https://www.cogedim.com/conseils-experts/risques-lies-a-linvestissement-pinel-lmnp-bouvard.html" style="color: #00b2a9;">cogedim.com</a>.
                                        </b>
                                        <br /><br />
                                        * Catégorie Promotion immobilière – Étude BVA – Viséo CI – Plus d’infos sur escda.fr
                                        <br />
                                        <?php if ($ml): ?>
                                            <?php echo $ml; ?>
                                        <?php endif ?>
                                        <br /><br />
                                        Si vous souhaitez vous désinscrire de notre newsletter, <a style="text-decoration:none;color:#48484c" title="Opt out" href="{{unsubscribe}}"> cliquez ici</a>
                                        <br /><br />
                                        Pour exercer vos droits d’accès, de rectification, d’effacement, d’opposition, de limitation et de portabilité vers un prestataire tiers le cas échéant, consultez notre politique de protection des données personnelles.
                                        <br /><br />
                                        Si vous avez des difficultés d'affichage :
                                        <br /><a style="text-decoration:none;color:#00b2a9" href="{{unsubscribe}}"> consultez la version en ligne</a>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <!--[if mso | IE]>
            </table>
            </tr>
            </td>
            <![endif]-->
        </center>
    </body>
</html>
